

//Import a library from the Arduino folder
#include <CapacitiveSensor.h>
/////////////////////////////// METTRE LE BON NOMBRE DE CAPTEURS /////////
byte Ncapteurs = 8;

//Select the two pins that will act as a capacitor
CapacitiveSensor   cs_2[] = {CapacitiveSensor(2, 3),// 10M resistor between pins 2 & 4, pin 2 is sensor pin, add a wire and or foil if desired
                             CapacitiveSensor(2, 4),// 10M resistor between pins 2 & 6, pin 6 is sensor pin, add a wire and or foi
                             CapacitiveSensor(2, 5),// 10M resistor between pins 2 & 11, pin 8 is sensor pin, add a wire and or foil
                             CapacitiveSensor(2, 6),// 10M resistor between pins 2 & 11, pin 8 is sensor pin, add a wire and or foil
                             CapacitiveSensor(2, 7),// 10M resistor between pins 2 & 11, pin 8 is sensor pin, add a wire and or foil
                             CapacitiveSensor(2, 8),// 10M resistor between pins 2 & 11, pin 8 is sensor pin, add a wire and or foil
                             CapacitiveSensor(2, 9),// 10M resistor between pins 2 & 11, pin 8 is sensor pin, add a wire and or foil
                             CapacitiveSensor(2, 10),// 10M resistor between pins 2 & 11, pin 8 is sensor pin, add a wire and or foil
                            };
long* capSensorVal ; // mémorise la valeur lue sur chaque capteurs

//Insert the minimum value provided by the sensor to detect the touch
int seuilDetection = 500; // seuil de détection sur la valeur donné par le capteur capacitif
const int ledPin = 13;

int* plante ;

// port série
int inByte = 0;

///////////////////// debug //////////////
boolean debug1 = false, debug2 = false;
////////////////////////////////////////////SETUP ////////////////////////////
void setup() {
  // start serial port at 9600 bps:
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }

  // création des tableaux
  capSensorVal = malloc(Ncapteurs * sizeof(long));
  plante = malloc(Ncapteurs * sizeof(int));
  // initialisation des tableaux
  for (int i = 0; i < Ncapteurs; i++) {
    capSensorVal[i] =  0;
    plante[i] = 0;
  }

  pinMode(ledPin, OUTPUT);
  // init des capteurs capacitifs
  cs_2[0].set_CS_AutocaL_Millis(0xFFFFFFFF);     // turn off autocalibrate on channel 1 - just as an example

  establishContact();  // send a byte to establish contact until receiver responds
}

void loop() {
  // if we get a valid byte, read analog ins:
  if (Serial.available() > 0) {
    // get incoming byte:
    inByte = Serial.read();

    long start = millis();
    for (int i = 0; i < Ncapteurs; i++) {
      capSensorVal[i] =  cs_2[i].capacitiveSensor(30);
    }

    if (debug1) {
      Serial.print(millis() - start);        // check on performance in milliseconds
      Serial.print("\t");                    // tab character for debug windown spacing

      for (int i = 0; i < Ncapteurs; i++) {
        Serial.print(capSensorVal[i]);                  // print sensor output 1
        Serial.print("\t");
      }
      Serial.println("");                // print sensor output 3
    }



    // test des valeurs des capteurs
    for (int i = 0; i < Ncapteurs; i++) {
      plante[i] = testCapteur(capSensorVal[i], seuilDetection);
    }
    if (debug2) {
      for (int i = 0; i < Ncapteurs; i++) {
        Serial.print(plante[i]);                  // print sensor output 1
        Serial.print("\t");
      }
      Serial.println("");                // print sensor output 3
    }
    else {
      // send sensor values: on envoie à Processing l'état de la plante - 0 : inactive; 255 : active
      for (int i = 0; i < Ncapteurs; i++) {
        Serial.write(plante[i]);
      }
    }
  }
}

void establishContact() {
  while (Serial.available() <= 0) {
    Serial.print('A');   // send a capital A
    delay(300);
  }
}

int testCapteur(long sensorVal, long seuilDetection) {
  // sensorVal : valeur du capteur
  // seuilDetection : seuil de détection

  if (sensorVal > seuilDetection ) {
    //Turn on the led
    digitalWrite(ledPin, HIGH);
    // plante i activée
    return 255;
  }
  //Touch undetected
  else {
    //Turn off the led
    digitalWrite(ledPin, LOW);
    // plante i inactivée
    return 0;
  }

}
